/*
    *****GLOBAL FIELD PROPERTY SET INCLUDE FILE Version 1.001*****
                        October 23, 1987


This include file provides examples of how to globally set the
properties of INGRES 5.0 vifred data fields.  The examples show how to
uniformly set uppercase, underline, intensity and no autotab for data
entry fields.  A means of restricting the scope of the procedure is
provide by the where clause "paifldflags.frid = "*"" where frid is the
form name.  To restrict the scope, replace the "*" with the
appropriate value. 

The procedrue, however, requires that the system catalog records in
"iicompfrm" for the affected forms be deleted.  This step is required
because iicompfrm stores compiled images of the forms which are not
updated by direct changes to the relations fdfields, fdtrim or
fdframes.  After successful completion of the procedure the user must
execute an "END TRANSACTION" and then go into VIFRED and resave all
affected forms. 

The user should be advised that RTI does not formally support this
update procedure. 

By: D. L. Gregory
    Palmer & Associates, Inc.
    3814 Satellite Blvd., Suite 200
    Atlanta, GA  30136-5058
    (404) 476-4482

*/


BEGIN TRANSACTION

RETRIEVE
(
    paifldflags.frid
   ,paifldflags.frowner
   ,paifldflags.fldname
   ,paifldflags.fltype
   ,paifldflags.flsubseq
   ,paifldflags.s_uppercase
   ,paifldflags.s_underline
   ,paifldflags.s_intensity
   ,paifldflags.s_noautotab
   ,paifldflags.fldatatype
   ,paifldflags.fldflags
)
WHERE
       paifldflags.frid        = "*"
   AND paifldflags.data_entry  = 1


SORT BY
   frid
  ,frowner
  ,flsubseq


/*
In the following replace operations it is not possible to update directly
through the view because of the aggregate in the view.  Therefore the view is
joined to the base table to performe the update.
*/

/* example replace for setting all user data entry fields to uppercase */

REPLACE fdfields
(
   fldflags = fdfields.fldflags +  128
)
WHERE
       paifldflags.frid        = "*"
   AND paifldflags.s_uppercase = 0
   AND paifldflags.data_entry  = 1
   AND fdfields.frid           = paifldflags.frid
   AND fdfields.frowner        = paifldflags.frowner
   AND fdfields.fldname        = paifldflags.fldname



/* example replace for setting all user data entry fields to underline */

REPLACE fdfields
(
   fldflags = fdfields.fldflags +  1024
)
WHERE
       paifldflags.frid        = "*"
   AND paifldflags.s_underline = 0
   AND paifldflags.data_entry  = 1
   AND fdfields.frid           = paifldflags.frid
   AND fdfields.frowner        = paifldflags.frowner
   AND fdfields.fldname        = paifldflags.fldname


/* example replace for setting all user data entry fields to high intensity */

REPLACE fdfields
(
   fldflags = fdfields.fldflags +  2048
)
WHERE
       paifldflags.frid        = "*"
   AND paifldflags.s_intensity = 0
   AND paifldflags.data_entry  = 1
   AND fdfields.frid           = paifldflags.frid
   AND fdfields.frowner        = paifldflags.frowner
   AND fdfields.fldname        = paifldflags.fldname


/* example replace for setting all user data entry fields to no autotab */

REPLACE fdfields
(
   fldflags = fdfields.fldflags +  4096
)
WHERE
       paifldflags.frid        = "*"
   AND paifldflags.s_noautotab = 0
   AND paifldflags.data_entry  = 1
   AND fdfields.frid           = paifldflags.frid
   AND fdfields.frowner        = paifldflags.frowner
   AND fdfields.fldname        = paifldflags.fldname


/* retrieve to verify results.  If incorrect results set - abort transaction */

RETRIEVE
(
    paifldflags.frid
   ,paifldflags.frowner
   ,paifldflags.fldname
   ,paifldflags.fltype
   ,paifldflags.flsubseq
   ,paifldflags.s_uppercase
   ,paifldflags.s_underline
   ,paifldflags.s_intensity
   ,paifldflags.s_noautotab
   ,paifldflags.fldatatype
   ,paifldflags.fldflags    
)
WHERE
       paifldflags.frid        = "*"
   AND paifldflags.data_entry  = 1

SORT BY
   frid
  ,frowner
  ,flsubseq

/* delete compiled form definitions */

DELETE iicompfrm
WHERE
       iicompfrm.cfname = "*"
